// Quartus II Verilog Template
// 4-State Moore state machine

// A Moore machine's outputs are dependent only on the current state.
// The output is written only when the state changes.  (State
// transitions are synchronous.)

module state_mach
(
	input	clk, reset,
	input [1:0] in,
	input [7:0] state0_out, state1_out,
	output reg [7:0] out
);

	// Declare state register
	reg	[1:0]	state;

	// Declare states
	parameter S0 = 0, S1 = 1, S2 = 2;

	// Output depends only on the state
	always @ (state or in or state0_out or state1_out) begin
		case (state)
		  S0:
		    out <= 8'b00000000;
			S1:
				out <= state0_out;
			S2:
				out <= state1_out;			
		default:
				out <= 8'b00000000;
		endcase
	end

	// Determine the next state
	always @ (posedge clk or posedge reset) begin
		if (reset)		
			state <= S0;
		else
			case (state)
				S0:
					if (in[0])
						state <= S1;
					else
						state <= S0;
				S1:
					if (in[1])
						state <= S2;
					else
						state <= S1;
				S2:
						state <= S2;
			/*	S3:
					if (in)
						state <= S2;
					else
						state <= S3;*/
			endcase
	end

endmodule
